/*
 * Decompiled with CFR 0.152.
 */
package badpenguin.dkim;

import badpenguin.dkim.DkimError;
import badpenguin.dkim.DkimException;
import badpenguin.dkim.NSKey;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class NSKeyStore {
    private static Hashtable<String, NSKey[]> keyMap = null;
    private DirContext dnsCtx = null;
    private int keyLimit;
    private int cacheTime;

    public NSKeyStore(String type, String nameServer) throws NamingException {
        if (!type.equalsIgnoreCase("dns")) {
            throw new NamingException("Only the DNS name service is supported");
        }
        this.keyLimit = 3;
        this.cacheTime = 900;
        keyMap = new Hashtable();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", "dns://" + nameServer);
        this.dnsCtx = new InitialDirContext(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NSKey[] retrieveKeys(String lookup) throws DkimException {
        boolean updating = false;
        NSKey[] cached = null;
        if (keyMap.containsKey(lookup)) {
            cached = keyMap.get(lookup);
            if (!cached[0].isExpired()) return cached;
            if (cached[0].setUpdating(true)) {
                updating = true;
            } else {
                int retries = cached[0].getRetries();
                if (retries <= 5) return cached;
                throw new DkimException(DkimError.TEMPFAIL, "Failed to perform NameService lookup");
            }
        }
        Attributes attrs = null;
        try {
            try {
                attrs = this.dnsCtx.getAttributes(lookup, new String[]{"txt"});
            }
            catch (NamingException e) {
                if (e.getMessage().contains("name not found")) {
                    throw new DkimException(DkimError.PERMFAIL, "No key for signature found at " + lookup, e);
                }
                if (updating) {
                    int retries = cached[0].getRetries();
                    if (retries > 5) {
                        throw new DkimException(DkimError.TEMPFAIL, "Failed to perform NameService lookup", e);
                    }
                    NSKey[] nSKeyArray = cached;
                    if (!updating) return nSKeyArray;
                    cached[0].setUpdating(false);
                    return nSKeyArray;
                }
                throw new DkimException(DkimError.TEMPFAIL, "Failed to perform NameService lookup", e);
            }
        }
        finally {
            if (updating) {
                cached[0].setUpdating(false);
            }
        }
        String[] record = attrs.toString().split(",");
        record[0] = record[0].replace("{txt=TXT: ", "");
        int keys = record.length;
        if (keys > this.keyLimit) {
            System.err.println("WARNING: Lookup \"" + lookup + "\" returned " + keys + " records." + " Only storing " + this.keyLimit + " of them.");
            keys = this.keyLimit;
        }
        NSKey[] nsKey = new NSKey[keys];
        int i = 0;
        while (i < keys) {
            nsKey[i] = new NSKey(record[i], this.cacheTime);
            ++i;
        }
        Hashtable<String, NSKey[]> hashtable = keyMap;
        synchronized (hashtable) {
            if (updating) {
                keyMap.remove(lookup);
            }
            if (keyMap.contains(lookup)) return nsKey;
            keyMap.put(lookup, nsKey);
            return nsKey;
        }
    }

    public int getKeyLimit() {
        return this.keyLimit;
    }

    public void setKeyLimit(int keyLimit) {
        this.keyLimit = keyLimit;
    }

    public void setCacheTime(int cacheTime) {
        this.cacheTime = cacheTime;
    }

    public int getCacheTime() {
        return this.cacheTime;
    }
}

