/*
 * Decompiled with CFR 0.152.
 */
package badpenguin.dkim.test;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;

public class KeyManager {
    KeyStore ks = null;
    String password = null;

    public KeyManager(FileInputStream store, String pass) {
        this.password = pass;
        try {
            this.ks = KeyStore.getInstance("JKS");
            this.ks.load(store, pass.toCharArray());
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("Failed to open keystore.");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PrivateKey getKey(String alias) {
        PrivateKey key = null;
        try {
            key = (PrivateKey)this.ks.getKey(alias, this.password.toCharArray());
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return key;
    }

    public PublicKey getCert(String alias) {
        PublicKey key = null;
        try {
            key = this.ks.getCertificate(alias).getPublicKey();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return key;
    }

    public Key getKey(String alias, String pass) {
        Key key = null;
        try {
            key = this.ks.getKey(alias, pass.toCharArray());
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return key;
    }
}

