/*
 * Decompiled with CFR 0.152.
 */
package badpenguin.dkim;

import badpenguin.dkim.DkimError;
import badpenguin.dkim.DkimException;
import java.security.PublicKey;
import java.util.Date;
import java.util.Scanner;
import sun.misc.BASE64Decoder;
import sun.security.rsa.RSAPublicKeyImpl;

public class NSKey {
    private PublicKey key = null;
    private String granularity = "*";
    private String hash = "sha1:sha256";
    private String notes = null;
    private String service = "*";
    private long expires;
    private String updating = "n";
    private int retries = 0;
    private DkimException dke;
    private boolean testing = false;
    private boolean noSubdomains = false;

    public NSKey(String record, int cacheTime) {
        Scanner keyScan = new Scanner(record);
        keyScan.useDelimiter("[\\;]");
        this.dke = null;
        this.expires = new Date().getTime() + (long)(cacheTime * 1000);
        while (keyScan.hasNext()) {
            String line = keyScan.next().replaceAll("[\t\" ]", "");
            String[] tag = line.trim().split("=", 2);
            if (tag[0].equals("g")) {
                this.granularity = tag[1];
                continue;
            }
            if (tag[0].equals("t")) {
                int i = 0;
                if (tag[1].contains("y")) {
                    this.testing = true;
                    ++i;
                    continue;
                }
                if (!tag[1].contains("s")) continue;
                this.noSubdomains = true;
                continue;
            }
            if (tag[0].equals("p")) {
                if (tag[1].isEmpty()) {
                    this.dke = new DkimException(DkimError.KEYREVOKED, "The Key has been revoked.");
                    return;
                }
                try {
                    BASE64Decoder decoder = new BASE64Decoder();
                    byte[] decoded = decoder.decodeBuffer(tag[1]);
                    this.key = new RSAPublicKeyImpl(decoded);
                    continue;
                }
                catch (Exception e) {
                    this.dke = new DkimException(DkimError.KEYSYNTAX, "The Key seems to be invalid", e);
                    return;
                }
            }
            if (tag[0].equals("v")) {
                if (tag[1].equals("DKIM1")) continue;
                this.dke = new DkimException(DkimError.KEYFAIL, "Unsupported DKIM version in txt record");
                return;
            }
            if (tag[0].equals("h")) {
                this.hash = tag[1];
                continue;
            }
            if (!tag[0].equals("k") || tag[1].equals("rsa")) continue;
            this.dke = new DkimException(DkimError.KEYALG, "Unsupported key type in txt record");
            return;
        }
        if (this.key == null) {
            this.dke = new DkimException(DkimError.KEYFAIL, "No KEY found in txt record");
            return;
        }
    }

    public boolean isExpired() {
        return new Date().getTime() > this.expires;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUpdating(boolean update) {
        String string = this.updating;
        synchronized (string) {
            block7: {
                block6: {
                    if (!update) break block6;
                    if (this.updating.equalsIgnoreCase("n")) {
                        this.updating = "y";
                        ++this.retries;
                        return true;
                    }
                    break block7;
                }
                if (update) break block7;
                this.updating = "n";
                return true;
            }
            return false;
        }
    }

    public int getRetries() {
        return this.retries;
    }

    public PublicKey getKey() throws DkimException {
        if (this.dke != null) {
            throw this.dke;
        }
        return this.key;
    }

    public boolean isTesting() {
        return this.testing;
    }

    public boolean noSubdomains() {
        return this.noSubdomains;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public String getHashAlgorithm() {
        return this.hash;
    }
}

