/*
 * Decompiled with CFR 0.152.
 */
package badpenguin.dkim;

import badpenguin.dkim.CanonicalMethod;
import badpenguin.dkim.DkimError;
import badpenguin.dkim.DkimException;
import java.util.Scanner;
import java.util.regex.Pattern;
import sun.misc.BASE64Encoder;

public class DkimSignature
implements Cloneable {
    private long sigLtag = -1L;
    private String sigVtag = "1";
    private String sigAtag = "\u0000";
    private String sigBtag = "\u0000";
    private String sigBHtag = "\u0000";
    private String sigCtag = "simple/simple";
    private String sigDtag = "\u0000";
    private String sigHtag = "\u0000";
    private String sigItag = "\u0000";
    private String sigQtag = "dns/txt";
    private String sigStag = "\u0000";
    private String sigTtag = "\u0000";
    private String sigXtag = "\u0000";
    private String sigZtag = "\u0000";
    private boolean isDKIM = false;
    private String dkimSig = null;

    public DkimSignature(String sig, boolean leniency) throws DkimException {
        if (sig.toLowerCase().startsWith("domainkey-signature")) {
            this.isDKIM = false;
            this.dkimSig = sig;
        } else if (sig.toLowerCase().startsWith("dkim-signature")) {
            this.isDKIM = true;
            this.dkimSig = sig;
        } else {
            throw new DkimException(DkimError.LIBERROR, "The provided signature is neither DKIM, nor DomainKey?");
        }
        if (leniency) {
            this.resetDefaultTags();
        } else {
            this.resetTags();
        }
        this.updateTagsfromSig();
    }

    public DkimSignature(String selector, String domain, String headers) throws DkimException {
        this.isDKIM = true;
        this.resetDefaultTags();
        this.sigHtag = headers;
        this.sigStag = selector;
        this.sigDtag = domain;
        this.updateSigfromTags();
    }

    public DkimSignature(String selector, String domain) throws DkimException {
        this.isDKIM = true;
        this.resetDefaultTags();
        this.sigHtag = "from:to:subject:message-id";
        this.sigStag = selector;
        this.sigDtag = domain;
        this.updateSigfromTags();
    }

    public DkimSignature clone() throws CloneNotSupportedException {
        return (DkimSignature)super.clone();
    }

    public void updateSigfromTags() {
        if (this.isDKIM) {
            this.dkimSig = "DKIM-Signature: ";
            this.dkimSig = String.valueOf(this.dkimSig) + "v=" + this.sigVtag + "; a=" + this.sigAtag + "; c=" + this.sigCtag + ";\r\n";
            this.dkimSig = String.valueOf(this.dkimSig) + "\td=" + this.sigDtag + "; s=" + this.sigStag;
            this.dkimSig = this.sigItag == "\u0000" ? String.valueOf(this.dkimSig) + ";\r\n" : String.valueOf(this.dkimSig) + "; i=" + this.sigItag + ";\r\n";
            if (this.sigLtag > -1L) {
                this.dkimSig = String.valueOf(this.dkimSig) + "\tl=" + this.sigLtag + ";\r\n";
            }
            if (this.sigXtag != "\u0000" && this.sigTtag != "\u0000") {
                this.dkimSig = String.valueOf(this.dkimSig) + "\tt=" + this.sigTtag + "; x=" + this.sigXtag + ";\r\n";
            } else if (this.sigTtag != "\u0000") {
                this.dkimSig = String.valueOf(this.dkimSig) + "\tt=" + this.sigTtag + ";\r\n";
            } else if (this.sigXtag != "\u0000") {
                this.dkimSig = String.valueOf(this.dkimSig) + "\tx=" + this.sigXtag + ";\r\n";
            }
            this.dkimSig = String.valueOf(this.dkimSig) + "\th=" + this.sigHtag + ";\r\n";
            this.dkimSig = String.valueOf(this.dkimSig) + "\tbh=" + this.sigBHtag + ";\r\n";
            this.dkimSig = this.sigBtag == "\u0000" ? String.valueOf(this.dkimSig) + "\tb=;" : String.valueOf(this.dkimSig) + "\tb=" + this.sigBtag.replaceAll("[\r\n]+", "\r\n\t") + ";\r\n";
        }
    }

    private void updateTagsfromSig() throws DkimException {
        Scanner dkim = new Scanner(this.dkimSig);
        dkim.useDelimiter(Pattern.compile(";"));
        dkim.skip(".*?:");
        while (dkim.hasNext()) {
            String[] tag = dkim.next().trim().split("=", 2);
            if (tag[0].equalsIgnoreCase("a")) {
                this.sigAtag = tag[1];
                if (this.sigAtag.equalsIgnoreCase("rsa-sha256") || this.sigAtag.equalsIgnoreCase("rsa-sha1")) continue;
                throw new DkimException(DkimError.SIGFAIL, "Message uses un-supported algorithm. Algorithm: " + this.sigAtag);
            }
            if (tag[0].equalsIgnoreCase("v")) {
                this.sigVtag = tag[1];
                if (this.sigVtag.equals("1")) continue;
                throw new DkimException(DkimError.SIGVERSION, "Message uses un-supported version of DKIM. Version: " + this.sigVtag);
            }
            if (tag[0].equalsIgnoreCase("c")) {
                if (this.isDKIM) {
                    String[] canon = tag[1].split("/");
                    if (canon.length == 1 || canon.length == 2) {
                        if (!canon[0].equalsIgnoreCase("simple") && !canon[0].equalsIgnoreCase("relaxed")) {
                            throw new DkimException(DkimError.SIGFAIL, "Message uses un-supported canonicalisation method. Method: " + canon[0]);
                        }
                        if (canon[0].equalsIgnoreCase("relaxed")) {
                            this.setMethod(CanonicalMethod.RELAXED);
                        } else {
                            this.setMethod(CanonicalMethod.SIMPLE);
                        }
                        if (canon.length != 2) continue;
                        if (!canon[1].equalsIgnoreCase("simple") && !canon[1].equalsIgnoreCase("relaxed")) {
                            throw new DkimException(DkimError.SIGFAIL, "Message uses un-supported canonicalisation method. Method: " + canon[1]);
                        }
                        if (canon[1].equalsIgnoreCase("relaxed")) {
                            this.setBodyMethod(CanonicalMethod.RELAXED);
                            continue;
                        }
                        this.setBodyMethod(CanonicalMethod.SIMPLE);
                        continue;
                    }
                    throw new DkimException(DkimError.SIGFAIL, "Message uses un-supported canonicalisation method. Methods: " + canon.toString());
                }
                if (!tag[1].equalsIgnoreCase("simple") && !tag[1].equalsIgnoreCase("nofws")) {
                    throw new DkimException(DkimError.badformat, "Invalid canonicalization specified");
                }
                if (tag[1].equalsIgnoreCase("nofws")) {
                    this.setMethod(CanonicalMethod.NOFWS);
                    continue;
                }
                this.setMethod(CanonicalMethod.SIMPLE);
                continue;
            }
            if (tag[0].equalsIgnoreCase("d")) {
                this.sigDtag = tag[1];
                continue;
            }
            if (tag[0].equalsIgnoreCase("s")) {
                this.sigStag = tag[1];
                continue;
            }
            if (tag[0].equalsIgnoreCase("h")) {
                this.sigHtag = tag[1];
                continue;
            }
            if (tag[0].equalsIgnoreCase("bh")) {
                this.sigBHtag = tag[1].replaceAll("\\p{javaWhitespace}", "");
                continue;
            }
            if (tag[0].equalsIgnoreCase("b")) {
                this.sigBtag = tag[1].replaceAll("\\p{javaWhitespace}", "");
                continue;
            }
            if (tag[0].equalsIgnoreCase("l")) {
                if (tag[1].length() > 10) {
                    throw new DkimException(DkimError.LIBERROR, "JavaDKIM limits message length tags at 2GB");
                }
                try {
                    this.sigLtag = Long.parseLong(tag[1]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new DkimException(DkimError.badformat, "Failed to parse (l)ength tag");
                }
            }
            if (tag[0].equalsIgnoreCase("i")) {
                this.sigItag = tag[1];
                continue;
            }
            if (tag[0].equalsIgnoreCase("q")) {
                this.sigQtag = tag[1];
                if (this.isDKIM && !this.sigQtag.equals("dns/txt")) {
                    throw new DkimException(DkimError.SIGFAIL, "Message uses un-supported query method. Method: " + this.sigQtag);
                }
                if (this.isDKIM || this.sigQtag.equals("dns")) continue;
                throw new DkimException(DkimError.badformat, "Message uses un-supported query method. Method: " + this.sigQtag);
            }
            if (tag[0].equalsIgnoreCase("t")) {
                this.sigTtag = tag[1];
                if (this.sigTtag.matches("[0-9]{1,12}")) continue;
                throw new DkimException(DkimError.SIGFAIL, "Message has an invalid timestamp. Message creation time: " + this.sigTtag);
            }
            if (tag[0].equalsIgnoreCase("x")) {
                this.sigXtag = tag[1];
                if (this.sigXtag.matches("[0-9]{1,12}")) continue;
                throw new DkimException(DkimError.SIGFAIL, "Message has an invalid timestamp. Message creation time: " + this.sigXtag);
            }
            if (!tag[0].equalsIgnoreCase("z")) continue;
            this.sigZtag = tag[1];
        }
    }

    public void checkValidity() throws DkimException {
        if (this.isDKIM) {
            this.checkDKIMValidity();
        } else {
            this.checkDomKeyValidity();
        }
    }

    private void checkDKIMValidity() throws DkimException {
        if (!this.sigVtag.equals("1")) {
            throw new DkimException(DkimError.SIGVERSION, "Incompatable Version");
        }
        if (this.sigAtag.equals("\u0000") || this.sigBtag.equals("\u0000") || this.sigBHtag.equals("\u0000") || this.sigDtag.equals("\u0000") || this.sigHtag.equals("\u0000") || this.sigStag.equals("\u0000")) {
            throw new DkimException(DkimError.SIGREQTAG, "signature missing required tag");
        }
        if (!this.sigHtag.toLowerCase().contains("from")) {
            throw new DkimException(DkimError.SIGFROM, "From field not signed");
        }
        if (!this.sigItag.equals("\u0000") && !this.sigItag.replaceAll(".*@(.*)", "$1").contains(this.sigDtag)) {
            throw new DkimException(DkimError.SIGDOMAIN, "Domain mismatch");
        }
    }

    private void checkDomKeyValidity() {
    }

    public String getAtag() {
        return this.sigAtag;
    }

    public void setAtag(String arg) throws DkimException {
        if (arg.equalsIgnoreCase("rsa-sha1")) {
            this.sigAtag = "rsa-sha1";
        } else if (arg.equalsIgnoreCase("rsa-sha256")) {
            this.sigAtag = "rsa-sha256";
        } else {
            throw new DkimException(DkimError.LIBERROR, "Invalid Algorithm specified");
        }
    }

    public String getBtag() {
        return this.sigBtag;
    }

    public void setBtag(String base64) {
        this.sigBtag = base64;
    }

    public void setBtag(byte[] data) {
        BASE64Encoder bs = new BASE64Encoder();
        this.sigBtag = bs.encode(data);
    }

    public String getBHtag() {
        return this.sigBHtag;
    }

    public void setBHtag(String base64) {
        this.sigBHtag = base64;
    }

    public void setBHtag(byte[] data) {
        BASE64Encoder bs = new BASE64Encoder();
        this.sigBHtag = bs.encode(data);
    }

    public String getVtag() {
        return this.sigVtag;
    }

    public void setVtag(String version) {
        this.sigVtag = version;
    }

    public String getCtag() {
        return this.sigCtag;
    }

    public long getLtag() {
        return this.sigLtag;
    }

    public void setLtag(long length) {
        this.sigLtag = length;
    }

    public String getHtag() {
        return this.sigHtag;
    }

    public void setHtag(String headers) throws DkimException {
        if (!headers.contains("from")) {
            throw new DkimException(DkimError.LIBERROR, "The H tag must include the \"From\" header!");
        }
        this.sigHtag = headers;
    }

    public String getItag() {
        return this.sigItag;
    }

    public void setItag(String arg0) {
        this.sigItag = arg0;
    }

    public String getDtag() {
        return this.sigDtag;
    }

    public void setDtag(String domain) {
        this.sigDtag = domain;
    }

    public String getStag() {
        return this.sigStag;
    }

    public void setStag(String selector) {
        this.sigStag = selector;
    }

    public String getTtag() {
        return this.sigTtag;
    }

    public void setTtag(String sigTtag) {
        this.sigTtag = sigTtag;
    }

    public String getXtag() {
        return this.sigXtag;
    }

    public void setXtag(String sigXtag) {
        this.sigXtag = sigXtag;
    }

    public void addHeader(String header) {
        this.sigHtag = String.valueOf(this.sigHtag) + ":" + header.replaceAll(":", "").toLowerCase();
    }

    public String getDnsRecord() throws DkimException {
        if (this.sigQtag.contains("dns")) {
            return String.valueOf(this.sigStag) + "._domainkey." + this.sigDtag;
        }
        throw new DkimException(DkimError.LIBERROR, "The Query tag does not specify a DNS record");
    }

    public String getJavaAlg() {
        if (this.sigAtag.equals("rsa-sha256")) {
            return "SHA256withRSA";
        }
        return "SHA1withRSA";
    }

    public String getAlgorithm() {
        return this.sigAtag;
    }

    public String getBodyHash() {
        return this.sigBHtag;
    }

    public String getMessageSignature() {
        return this.sigBtag;
    }

    public boolean isDKIM() {
        return this.isDKIM;
    }

    public CanonicalMethod getHeaderMethod() {
        if (this.sigCtag.startsWith("simple")) {
            return CanonicalMethod.SIMPLE;
        }
        if (this.sigCtag.startsWith("relaxed")) {
            return CanonicalMethod.RELAXED;
        }
        return CanonicalMethod.NOFWS;
    }

    public CanonicalMethod getBodyMethod() {
        if (this.sigCtag.contains("/simple")) {
            return CanonicalMethod.SIMPLE;
        }
        if (this.sigCtag.contains("/relaxed")) {
            return CanonicalMethod.RELAXED;
        }
        return this.getHeaderMethod();
    }

    public void setHeaderMethod(CanonicalMethod method) throws DkimException {
        if (!this.isDKIM) {
            throw new DkimException(DkimError.LIBERROR, "You can not specify differing body/header canonicalisation on a DomainKey signature");
        }
        String[] canon = this.sigCtag.split("/");
        if (canon[1] == null) {
            canon[1] = canon[0];
        }
        if (method.equals((Object)CanonicalMethod.RELAXED)) {
            this.sigCtag = "relaxed/" + canon[1];
        } else if (method.equals((Object)CanonicalMethod.SIMPLE)) {
            this.sigCtag = "simple/" + canon[1];
        } else {
            throw new DkimException(DkimError.LIBERROR, "Invalid canonical method for DKIM signature");
        }
    }

    public void setBodyMethod(CanonicalMethod method) throws DkimException {
        if (!this.isDKIM) {
            throw new DkimException(DkimError.LIBERROR, "You can not specify differing body/header canonicalisation on a DomainKey signature");
        }
        String[] canon = this.sigCtag.split("/");
        if (canon[1] == null) {
            canon[1] = canon[0];
        }
        if (method.equals((Object)CanonicalMethod.RELAXED)) {
            this.sigCtag = String.valueOf(canon[0]) + "/relaxed";
        } else if (method.equals((Object)CanonicalMethod.SIMPLE)) {
            this.sigCtag = String.valueOf(canon[0]) + "/simple";
        } else {
            throw new DkimException(DkimError.LIBERROR, "Invalid canonical method for DKIM signature");
        }
    }

    public void setMethod(CanonicalMethod method) throws DkimException {
        if (!this.isDKIM && method.equals((Object)CanonicalMethod.RELAXED)) {
            throw new DkimException(DkimError.LIBERROR, "You can not set relaxed canonicalisation on a DomainKey signature");
        }
        if (this.isDKIM && method.equals((Object)CanonicalMethod.NOFWS)) {
            throw new DkimException(DkimError.LIBERROR, "You can not set nofws canonicalisation on a DKIM Signature");
        }
        this.sigCtag = method.equals((Object)CanonicalMethod.RELAXED) ? "relaxed/relaxed" : (method.equals((Object)CanonicalMethod.NOFWS) ? "nofws" : (this.isDKIM ? "simple/simple" : "simple"));
    }

    public String genDkimSig() {
        this.updateSigfromTags();
        return this.dkimSig;
    }

    public String getDkimSig() {
        return this.dkimSig;
    }

    public void resetTags() {
        this.sigBHtag = "\u0000";
        this.sigBtag = "\u0000";
        this.sigAtag = "\u0000";
        this.sigVtag = "\u0000";
        this.sigStag = "\u0000";
        this.sigItag = "\u0000";
        this.sigHtag = "\u0000";
        this.sigDtag = "\u0000";
        this.sigZtag = "\u0000";
        this.sigXtag = "\u0000";
        this.sigTtag = "\u0000";
        this.sigStag = "\u0000";
        this.sigLtag = -1L;
        if (this.isDKIM) {
            this.sigCtag = "simple/simple";
            this.sigQtag = "dns/txt";
        } else {
            this.sigCtag = "\u0000";
            this.sigQtag = "dns";
            this.sigAtag = "rsa-sha1";
        }
    }

    public void resetDefaultTags() {
        this.sigBHtag = "\u0000";
        this.sigBtag = "\u0000";
        this.sigStag = "\u0000";
        this.sigItag = "\u0000";
        this.sigHtag = "\u0000";
        this.sigDtag = "\u0000";
        this.sigZtag = "\u0000";
        this.sigXtag = "\u0000";
        this.sigTtag = "\u0000";
        this.sigStag = "\u0000";
        this.sigVtag = "1";
        this.sigLtag = -1L;
        if (this.isDKIM) {
            this.sigAtag = "rsa-sha256";
            this.sigCtag = "simple/simple";
            this.sigQtag = "dns/txt";
        } else {
            this.sigAtag = "rsa-sha1";
            this.sigCtag = "simple";
            this.sigQtag = "dns";
        }
    }
}

