/*
 * Decompiled with CFR 0.152.
 */
package badpenguin.dkim;

import badpenguin.dkim.ErrorType;

public enum DkimError {
    good("good", ErrorType.PASS, "The signature was verified at the time of testing"),
    bad("bad", ErrorType.PERMFAIL, "The signature failed verification"),
    nokey("no key", ErrorType.PERMFAIL, "The public key query failed as the key does not exist"),
    revoked("revoked", ErrorType.PERMFAIL, "The public key query failed as the key has been revoked"),
    badformat("bad format", ErrorType.PERMFAIL, "The signature or the public key contains unexpected data"),
    participant("non-participant", ErrorType.PERMFAIL, "The sending domain has indicated it does not participate in DomainKeys"),
    TEMPFAIL("TEMPFAIL", ErrorType.TEMPFAIL, "Temporary Failure encountered. Message may validate later"),
    PERMFAIL("PERMFAIL", ErrorType.PERMFAIL, "Permenant Failure encountered. Message will never validate"),
    SIGSYNTAX("PERMFAIL - SIGSYNTAX", ErrorType.PERMFAIL, "(Signature Syntax Error)"),
    SIGVERSION("PERMFAIL - SIGVERSION", ErrorType.PERMFAIL, "(Incompatible Version)"),
    SIGREQTAG("PERMFAIL - SIGREQTAG", ErrorType.PERMFAIL, "(Signature Missing Required Tag)"),
    SIGDOMAIN("PERMFAIL - SIGDOMAIN", ErrorType.PERMFAIL, "(Domain Mismatch)"),
    SIGFROM("PERMFAIL - SIGFROM", ErrorType.PERMFAIL, "(From Header Not Signed)"),
    SIGEXPIRED("PERMFAIL - SIGEXPIRED", ErrorType.PERMFAIL, "(Signature Expired)"),
    SIGFAIL("PERMFAIL - SIGFAIL", ErrorType.PERMFAIL, "(Unacceptable Signature Header)"),
    KEYUNVAIL("TEMPFAIL - KEYUNAVAIL", ErrorType.TEMPFAIL, "(Key Unavailable)"),
    NOKEY("PERMFAIL - NOKEY", ErrorType.PERMFAIL, "(No Key For Signature)"),
    KEYSYNTAX("PERMFAIL - KEYSYNTAX", ErrorType.PERMFAIL, "(Key Syntax Error)"),
    KEYFAIL("PERMFAIL - KEYFAIL", ErrorType.PERMFAIL, "(Inapplicable Key)"),
    KEYHASH("PERMFAIL - KEYHASH", ErrorType.PERMFAIL, "(Inappropriate Hash Algorithm)"),
    KEYREVOKED("PERMFAIL - KEYREVOKED", ErrorType.PERMFAIL, "(Key Revoked)"),
    KEYALG("PERMFAIL - KEYALG", ErrorType.PERMFAIL, "(Inappropriate Key Algorithm)"),
    BODYHASH("PERMFAIL - BODYHASH", ErrorType.PERMFAIL, "(Body Hash Did Not Verify)"),
    SIGVERIFY("PERMFAIL - SIGVERIFY", ErrorType.PERMFAIL, "(Signature Did Not Verify)"),
    CONTENT("PERMFAIL - CONTENT", ErrorType.PERMFAIL, "(Unsigned Content)"),
    NOSIG("NOSIG", ErrorType.NOSIG, "This email has no DomainKey-Signature / DKIM header"),
    LIBERROR("LIBERROR", ErrorType.LIBERROR, "An internal error has occurred");

    private String status;
    private String description;
    public ErrorType errorType;

    private DkimError(String arg1, ErrorType arg2, String arg3) {
        this.status = arg1;
        this.errorType = arg2;
        this.description = arg3;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }
}

