/*
 * Decompiled with CFR 0.152.
 */
package badpenguin.dkim.test;

import badpenguin.dkim.DkimException;
import badpenguin.dkim.ErrorType;
import badpenguin.dkim.NSKeyStore;
import badpenguin.dkim.Verifier;
import java.io.FileInputStream;

public class VerifyMail {
    public static void main(String[] args) {
        VerifyMail vm = new VerifyMail();
        if (args.length < 2) {
            System.err.println("The badpenguin.dkim.test package contains simple utilities for testing DKIM\n");
            System.err.println("Usage: VerifyMail <nameserver> <filename>");
            System.exit(1);
        }
        vm.run(args[0], args[1]);
    }

    public void run(String nameserver, String filename) {
        FileInputStream msg = null;
        try {
            NSKeyStore keyStore = new NSKeyStore("dns", nameserver);
            keyStore.setKeyLimit(5);
            Verifier ver = new Verifier(keyStore, "DKIM");
            ver.setleniency(true);
            msg = new FileInputStream(filename);
            ver.setMaximumSigs(3);
            ver.verifyMail(msg);
            System.out.println("Message Verified :-)");
            msg.close();
        }
        catch (DkimException d) {
            try {
                msg.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (d.getErrorType() == ErrorType.NOSIG) {
                System.err.println("NOSIG -- " + d.getError().getStatus());
                System.err.println(d.getError().getDescription());
                System.err.println(d.getMessage());
                d.printStackTrace();
            } else if (d.getErrorType().equals((Object)ErrorType.TEMPFAIL)) {
                System.err.println("TEMPFAIL -- " + d.getError().getStatus());
                System.err.println(d.getError().getDescription());
                System.err.println(d.getMessage());
                d.printStackTrace();
            } else if (d.getErrorType() == ErrorType.PERMFAIL) {
                System.err.println("PERMFAIL -- " + d.getError().getStatus());
                System.err.println(d.getError().getDescription());
                System.err.println(d.getMessage());
                d.printStackTrace();
            } else {
                System.err.println(d.getError().getStatus());
                System.err.println(d.getError().getDescription());
                System.err.println(d.getMessage());
                d.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

