/*
 * Decompiled with CFR 0.152.
 */
package badpenguin.dkim;

import badpenguin.dkim.Canonicaliser;
import badpenguin.dkim.DkimError;
import badpenguin.dkim.DkimException;
import badpenguin.dkim.DkimSignature;
import badpenguin.dkim.ErrorType;
import badpenguin.dkim.MailMessage;
import badpenguin.dkim.NSKey;
import badpenguin.dkim.NSKeyStore;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import java.util.Vector;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Verifier {
    private String sigPref = null;
    private boolean leniency = false;
    private NSKeyStore keyStore = null;
    private boolean tryBoth = false;
    private Vector<String> badDomains = null;
    private int maxSigs;

    public Verifier(NSKeyStore keyStore, String sigPref, boolean tryBoth) {
        this._Verifier(keyStore, sigPref, tryBoth);
    }

    public Verifier(NSKeyStore keyStore, String sigPref) {
        this._Verifier(keyStore, sigPref, true);
    }

    public Verifier(NSKeyStore keyStore) {
        this._Verifier(keyStore, "DKIM", true);
    }

    private void _Verifier(NSKeyStore keyStore, String sigPref, boolean tryBoth) {
        this.tryBoth = tryBoth;
        this.sigPref = sigPref;
        this.keyStore = keyStore;
        this.leniency = false;
        this.badDomains = new Vector();
        this.maxSigs = 1;
    }

    public void setleniency(boolean leniency) {
        this.leniency = leniency;
    }

    public void tryBoth(boolean tryBoth) {
        this.tryBoth = tryBoth;
    }

    public void setBadDomains(String[] domains) {
        int i = 0;
        while (i < domains.length) {
            this.badDomains.add(domains[i]);
            ++i;
        }
    }

    public void addBadDomain(String domain) {
        this.badDomains.add(domain);
    }

    public void setMaximumSigs(int maxSigs) {
        if (maxSigs < 1) {
            maxSigs = 1;
        }
        this.maxSigs = maxSigs;
    }

    public int getMaximumSigs() {
        return this.maxSigs;
    }

    private void checkBadDomains(DkimSignature dkimSig, boolean isDKIM) throws DkimException {
        String domain = dkimSig.getDtag();
        if (this.badDomains.contains(domain)) {
            if (isDKIM) {
                throw new DkimException(DkimError.SIGFAIL, "The message is signed by an untrusted/Bad domain");
            }
            throw new DkimException(DkimError.bad, "The message is signed by an untrusted/Bad domain");
        }
    }

    private void checkBodyHash(DkimSignature dkimSig, String mailBody) throws DkimException {
        MessageDigest md = null;
        try {
            md = dkimSig.getJavaAlg().equals("SHA256withRSA") ? MessageDigest.getInstance("SHA-256") : MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DkimException(DkimError.LIBERROR, "Java couldn't find the required hash algorithm", e);
        }
        md.update(mailBody.getBytes());
        BASE64Encoder bsenc = new BASE64Encoder();
        String digest = bsenc.encode(md.digest());
        if (!digest.equals(dkimSig.getBodyHash())) {
            throw new DkimException(DkimError.BODYHASH, "The body hash did not verify.");
        }
    }

    private void checkExpireTime(DkimSignature dkimSig, long receivedTime) throws DkimException {
        Long time;
        String xtag = dkimSig.getXtag();
        if (xtag.equals("\u0000")) {
            return;
        }
        if (xtag.length() > 12) {
            throw new DkimException(DkimError.SIGSYNTAX, "The expires tag is > 12 chars");
        }
        Long expires = Long.parseLong(xtag);
        String ttag = dkimSig.getTtag();
        if (!ttag.equals("\u0000") && (time = Long.valueOf(Long.parseLong(ttag))) > expires) {
            throw new DkimException(DkimError.SIGFAIL, "The timestamp tag is newer than the expire tag");
        }
        long now = 0L;
        now = receivedTime == 0L ? new Date().getTime() / 1000L : receivedTime;
        if (expires - now < 0L) {
            throw new DkimException(DkimError.SIGEXPIRED, "The Signature has expired");
        }
    }

    private void checkGranularity(DkimSignature dkimSig, NSKey nsKey) throws DkimException {
        int local;
        String granularity = nsKey.getGranularity();
        if (granularity.equals("*")) {
            return;
        }
        if (this.leniency && granularity.isEmpty()) {
            return;
        }
        String iTag = dkimSig.getItag();
        if (!iTag.equals("\u0000") && (local = iTag.indexOf("@")) > 0) {
            granularity = granularity.replaceAll("\\*", ".*");
            if (!iTag.substring(0, local).matches(granularity)) {
                throw new DkimException(DkimError.KEYFAIL, "Key Granularity is not applicable for Signature");
            }
        }
    }

    private void checkSubdomains(DkimSignature dkimSig, NSKey nsKey) throws DkimException {
        if (nsKey.noSubdomains()) {
            String Itag = dkimSig.getItag();
            if (Itag.equals("\u0000")) {
                return;
            }
            String domain = Itag.substring(Itag.indexOf(64) + 1);
            if (!domain.equals(dkimSig.getDtag())) {
                throw new DkimException(DkimError.KEYFAIL, "Key can not be used for sub-domains");
            }
        }
    }

    private void checkHashAlgorithm(DkimSignature dkimSig, NSKey nsKey) throws DkimException {
        String Atag = dkimSig.getAtag();
        String[] hashes = nsKey.getHashAlgorithm().split(":");
        int i = 0;
        while (i < hashes.length) {
            if (Atag.endsWith(hashes[i])) {
                return;
            }
            ++i;
        }
        throw new DkimException(DkimError.KEYHASH, "The key algorithm does not match the Signature.");
    }

    public void verifyMail(InputStream msg) throws IOException, DkimException {
        this.verifyMail(msg, 0L);
    }

    /*
     * Unable to fully structure code
     */
    public void verifyMail(InputStream msg, long receivedTime) throws IOException, DkimException {
        block20: {
            block21: {
                canon = new Canonicaliser(this.sigPref);
                mail = new MailMessage();
                mail.processMail(msg);
                dkimHeaders = mail.dkimHeaderCount();
                domkeyHeaders = mail.domkeyHeaderCount();
                if (dkimHeaders == 0 && domkeyHeaders == 0) {
                    throw new DkimException(DkimError.NOSIG, "There are no Signatures in this message");
                }
                if (dkimHeaders == 0 && this.sigPref.equalsIgnoreCase("DKIM") && !this.tryBoth) {
                    throw new DkimException(DkimError.NOSIG, "There are no DKIM Signatures in this message");
                }
                if (domkeyHeaders == 0 && this.sigPref.equalsIgnoreCase("DomainKey") && !this.tryBoth) {
                    throw new DkimException(DkimError.NOSIG, "There are no DomainKey Signatures in this message");
                }
                if (this.maxSigs == 1) break block20;
                tries = 0;
                tempFail = null;
                lastFail = null;
                canon.initVerify(mail.getHeaders());
                dkimSigs = canon.getDkimHeaders();
                domkeySigs = canon.getDomKeyHeaders();
                if (!this.sigPref.equalsIgnoreCase("DKIM")) ** GOTO lbl55
                while (!dkimSigs.isEmpty() && tries < this.maxSigs) {
                    ++tries;
                    try {
                        dkimSig = new DkimSignature(dkimSigs.pop(), this.leniency);
                        this.processSignature(dkimSig, canon, mail, receivedTime);
                        return;
                    }
                    catch (DkimException dke) {
                        if (dke.getErrorType().equals((Object)ErrorType.TEMPFAIL)) {
                            tempFail = dke;
                            continue;
                        }
                        lastFail = dke;
                    }
                }
                while (this.tryBoth && !domkeySigs.isEmpty() && tries < this.maxSigs) {
                    ++tries;
                    try {
                        dkimSig = new DkimSignature(domkeySigs.pop(), this.leniency);
                        this.processSignature(dkimSig, canon, mail, receivedTime);
                        return;
                    }
                    catch (DkimException dke) {
                        if (dke.getErrorType().equals((Object)ErrorType.TEMPFAIL)) {
                            tempFail = dke;
                            continue;
                        }
                        lastFail = dke;
                    }
                }
                break block21;
lbl-1000:
                // 1 sources

                {
                    ++tries;
                    try {
                        dkimSig = new DkimSignature(domkeySigs.pop(), this.leniency);
                        this.processSignature(dkimSig, canon, mail, receivedTime);
                        return;
                    }
                    catch (DkimException dke) {
                        if (dke.getErrorType().equals((Object)ErrorType.TEMPFAIL)) {
                            tempFail = dke;
                            continue;
                        }
                        lastFail = dke;
                    }
lbl55:
                    // 3 sources

                    ** while (!domkeySigs.isEmpty() && tries < this.maxSigs)
                }
lbl56:
                // 3 sources

                while (this.tryBoth && !dkimSigs.isEmpty() && tries < this.maxSigs) {
                    ++tries;
                    try {
                        dkimSig = new DkimSignature(dkimSigs.pop(), this.leniency);
                        this.processSignature(dkimSig, canon, mail, receivedTime);
                        return;
                    }
                    catch (DkimException dke) {
                        if (dke.getErrorType().equals((Object)ErrorType.TEMPFAIL)) {
                            tempFail = dke;
                            continue;
                        }
                        lastFail = dke;
                    }
                }
            }
            if (tempFail != null) {
                throw tempFail;
            }
            throw lastFail;
        }
        dkimSig = new DkimSignature(canon.initVerify(mail.getHeaders(), this.tryBoth), this.leniency);
        this.processSignature(dkimSig, canon, mail, receivedTime);
    }

    private void processSignature(DkimSignature dkimSig, Canonicaliser canon, MailMessage mail, long receivedTime) throws IOException, DkimException {
        Signature sig = null;
        String mailHeaders = canon.processHeaders(dkimSig);
        dkimSig.checkValidity();
        boolean dkim = dkimSig.isDKIM();
        this.checkExpireTime(dkimSig, receivedTime);
        this.checkBadDomains(dkimSig, dkim);
        String mailBody = canon.processBody(mail.getBody(), dkimSig.getLtag(), dkimSig.getBodyMethod());
        NSKey[] nsKeys = this.keyStore.retrieveKeys(dkimSig.getDnsRecord());
        NSKey nsKey = null;
        String keyErrors = null;
        DkimException dke = null;
        int i = 0;
        while (i < nsKeys.length) {
            try {
                nsKeys[i].getKey();
                this.checkGranularity(dkimSig, nsKeys[i]);
                this.checkSubdomains(dkimSig, nsKeys[i]);
                this.checkHashAlgorithm(dkimSig, nsKeys[i]);
                nsKey = nsKeys[i];
                break;
            }
            catch (DkimException e) {
                if (keyErrors == null) {
                    dke = e;
                    keyErrors = "Key " + i + ": " + e.getMessage();
                } else {
                    keyErrors = keyErrors.concat(", Key " + i + ": " + e.getMessage());
                    dke = new DkimException(e.getError(), keyErrors);
                }
                ++i;
            }
        }
        if (nsKey == null) {
            throw dke;
        }
        if (dkim) {
            this.checkBodyHash(dkimSig, mailBody);
        }
        BASE64Decoder bs = new BASE64Decoder();
        byte[] sigBuf = bs.decodeBuffer(dkimSig.getBtag());
        try {
            sig = Signature.getInstance(dkimSig.getJavaAlg());
            sig.initVerify(nsKey.getKey());
            sig.update(mailHeaders.getBytes());
            if (!dkim) {
                sig.update("\r\n".getBytes());
                sig.update(mailBody.getBytes());
            }
            if (sig.verify(sigBuf)) {
                return;
            }
            if (dkim) {
                throw new DkimException(DkimError.SIGFAIL, "Message Verification Failed.");
            }
            throw new DkimException(DkimError.bad, "Message Verification Failed.");
        }
        catch (NoSuchAlgorithmException n) {
            n.printStackTrace();
        }
        catch (InvalidKeyException k) {
            if (dkim) {
                throw new DkimException(DkimError.KEYSYNTAX, "The Key found was invalid", k);
            }
            throw new DkimException(DkimError.badformat, "The Key found was invalid", k);
        }
        catch (SignatureException s) {
            if (dkim) {
                throw new DkimException(DkimError.SIGFAIL, "Could not process the signature data", s);
            }
            throw new DkimException(DkimError.badformat, "The Key found was invalid", s);
        }
    }
}

