/*
 * Decompiled with CFR 0.152.
 */
package badpenguin.dkim;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import java.util.regex.Pattern;

public class MailMessage {
    private ByteArrayOutputStream headerStream = new ByteArrayOutputStream();
    private ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();
    private int dkimHeaders = 0;
    private int domkeyHeaders = 0;

    public void processMail(InputStream msg) {
        String line;
        Scanner mail = new Scanner(msg);
        mail.useDelimiter(Pattern.compile("[\r\n]"));
        try {
            while (mail.hasNextLine()) {
                line = mail.nextLine();
                if (!line.isEmpty()) {
                    if (line.toLowerCase().startsWith("domainkey-dignature:")) {
                        ++this.domkeyHeaders;
                    }
                    if (line.toLowerCase().startsWith("dkim-signature")) {
                        ++this.dkimHeaders;
                    }
                    line = String.valueOf(line) + "\r\n";
                    this.headerStream.write(line.getBytes());
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.err.println("Encountered IO Error while buffering headers");
            e.printStackTrace();
        }
        try {
            while (mail.hasNextLine()) {
                line = mail.nextLine();
                line = String.valueOf(line) + "\r\n";
                this.bodyStream.write(line.getBytes());
            }
        }
        catch (IOException e) {
            System.err.println("Encountered IO Error while buffering message body");
            e.printStackTrace();
        }
    }

    public ByteArrayOutputStream getHeaders() {
        return this.headerStream;
    }

    public ByteArrayOutputStream getBody() {
        return this.bodyStream;
    }

    public int dkimHeaderCount() {
        return this.dkimHeaders;
    }

    public int domkeyHeaderCount() {
        return this.domkeyHeaders;
    }
}

