/*
 * Decompiled with CFR 0.152.
 */
package badpenguin.dkim;

import badpenguin.dkim.CanonicalMethod;
import badpenguin.dkim.DkimError;
import badpenguin.dkim.DkimException;
import badpenguin.dkim.DkimSignature;
import java.io.ByteArrayOutputStream;
import java.util.Scanner;
import java.util.Stack;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Canonicaliser {
    private static final CanonicalMethod SIMPLE = CanonicalMethod.SIMPLE;
    private static final CanonicalMethod RELAXED = CanonicalMethod.RELAXED;
    private static final CanonicalMethod NOFWS = CanonicalMethod.NOFWS;
    private static String[] RFCHEADERS = new String[]{"From", "Sender", "Reply-To", "Subject", "Date", "Message-ID", "To", "Cc", "MIME-Version", "Content-Type", "Content-Transfer-Encoding", "Content-ID", "Content-Description", "Resent-Date", "Resent-From", "Resent-Sender", "Resent-To", "Resent-Cc", "Resent-Message-ID", "In-Reply-To", "References", "List-Id", "List-Help", "List-Unsubscribe", "List-Subscribe", "List-Post", "List-Owner", "List-Archive"};
    private boolean useDKIM = false;
    private boolean fallBack = false;
    private boolean isSigning = false;
    private Stack<String> headerStack = null;
    private String signHeaders = null;
    private Stack<String> dkimSigs = null;
    private Stack<String> domKeySigs = null;

    public Canonicaliser(String sigPref) {
        this.useDKIM = sigPref.equalsIgnoreCase("DKIM") ? true : !sigPref.equalsIgnoreCase("DomainKey");
        this.fallBack = false;
    }

    public Canonicaliser() {
        this.useDKIM = true;
        this.fallBack = false;
    }

    public String getRecommendedHeaders() throws DkimException {
        if (this.headerStack == null) {
            throw new DkimException(DkimError.LIBERROR, "You must call initHeaders first!");
        }
        String headers = RFCHEADERS[0];
        int i = 1;
        while (i < RFCHEADERS.length) {
            if (this.headerStack.contains(RFCHEADERS[i])) {
                headers = String.valueOf(headers) + ":" + RFCHEADERS[i];
            }
            ++i;
        }
        return headers.toLowerCase();
    }

    protected String processLine(String line, CanonicalMethod method) {
        if (method.equals((Object)NOFWS)) {
            line = line.replaceAll("[\t\r\n ]", "");
            line = String.valueOf(line) + "\r\n";
        } else if (method.equals((Object)RELAXED)) {
            line = line.replaceAll("[\r\n\t ]+", " ");
            line = line.replaceAll("(?m)[\t\r\n ]+$", "");
            line = String.valueOf(line) + "\r\n";
        } else if (method.equals((Object)SIMPLE)) {
            line = String.valueOf(line) + "\r\n";
        }
        return line;
    }

    public String processBody(ByteArrayOutputStream bodyStream, long length, CanonicalMethod method) throws DkimException {
        String mailBody = "";
        if (length == 0L) {
            return "";
        }
        Scanner mail = new Scanner(bodyStream.toString());
        mail.useDelimiter(Pattern.compile("[\r\n]"));
        while (mail.hasNextLine()) {
            String line = mail.nextLine();
            mailBody = String.valueOf(mailBody) + this.processLine(line, method);
        }
        mailBody = mailBody.replaceFirst("[\r\n]*$", "\r\n");
        if (length > 0L) {
            String truncated = "";
            byte[] body = mailBody.getBytes();
            if (length > (long)body.length) {
                throw new DkimException(DkimError.SIGFAIL, "The (L)ength tag is larger than the messages actual length");
            }
            int c = 0;
            while ((long)c < length) {
                truncated = String.valueOf(truncated) + (char)body[c];
                ++c;
            }
            return truncated;
        }
        return mailBody;
    }

    /*
     * Unable to fully structure code
     */
    public String processHeaders(DkimSignature dkimSig) throws DkimException {
        block13: {
            myStack = (Stack)this.headerStack.clone();
            this.signHeaders = "";
            if (this.headerStack == null || myStack == null) {
                throw new DkimException(DkimError.LIBERROR, "You must call initHeaders first!");
            }
            sigHtag = dkimSig.getHtag();
            method = dkimSig.getHeaderMethod();
            isDKIM = dkimSig.isDKIM();
            if (isDKIM && (sigHtag == null || sigHtag.isEmpty())) {
                throw new DkimException(DkimError.SIGREQTAG, "The madatory H tag appears to be missing from the DKIM-Signature");
            }
            if (sigHtag == "\u0000") ** GOTO lbl52
            if (isDKIM) {
                sigHtag = String.valueOf(sigHtag) + ":DKIM-Signature";
            }
            headers = sigHtag.split("\\s*:\\s*");
            headerCount = headers.length;
            values = new String[headerCount];
            block0: while (!myStack.isEmpty()) {
                header = (String)myStack.pop();
                index = 0;
                while (index < headerCount) {
                    if (header.trim().equalsIgnoreCase(headers[index].trim())) {
                        headers[index] = header;
                        if (values[index] == null) {
                            if (headers[index].equalsIgnoreCase("dkim-signature") && !this.isSigning) {
                                values[index] = (String)myStack.pop();
                                pattern = Pattern.compile(".*?b=(.*?)[\\s;].*");
                                matcher = pattern.matcher(values[index]);
                                bt = null;
                                if (!matcher.find()) continue block0;
                                bt = matcher.group(1);
                                if (dkimSig.getBtag().contains(bt)) {
                                    values[index] = values[index].replaceFirst("b=[A-Za-z0-9+/=\r\n\t ]+", "b=");
                                    continue block0;
                                }
                                values[index] = null;
                                continue block0;
                            }
                            values[index] = (String)myStack.pop();
                            continue block0;
                        }
                    }
                    ++index;
                }
            }
            if (this.isSigning) {
                values[headerCount - 1] = this.processLine(dkimSig.genDkimSig().substring(15), method);
            }
            index = 0;
            while (index < headers.length) {
                this.signHeaders = method.equals((Object)Canonicaliser.RELAXED) != false ? String.valueOf(this.signHeaders) + this.processLine(String.valueOf(headers[index].toLowerCase().trim()) + ":" + values[index].trim(), method) : (method.equals((Object)Canonicaliser.NOFWS) != false ? String.valueOf(this.signHeaders) + this.processLine(String.valueOf(headers[index].trim()) + ":" + values[index].trim(), method) : String.valueOf(this.signHeaders) + this.processLine(String.valueOf(headers[index]) + ":" + values[index], method));
                ++index;
            }
            break block13;
lbl-1000:
            // 1 sources

            {
                header = (String)myStack.pop();
                value = (String)myStack.pop();
                if (header.equalsIgnoreCase("DomainKey-Signature")) continue;
                this.signHeaders = String.valueOf(this.processLine(String.valueOf(header) + ":" + value, method)) + this.signHeaders;
lbl52:
                // 3 sources

                ** while (!myStack.isEmpty())
            }
        }
        if (isDKIM) {
            this.signHeaders = this.signHeaders.replaceAll("(?m)[\r\n]+$", "");
        }
        return this.signHeaders;
    }

    public String initVerify(ByteArrayOutputStream headerStream, boolean fallback) throws DkimException {
        this.headerStack = new Stack();
        this.signHeaders = null;
        this.fallBack = fallback;
        this.isSigning = false;
        return this.init(headerStream, false);
    }

    public void initVerify(ByteArrayOutputStream headerStream) throws DkimException {
        this.headerStack = new Stack();
        this.signHeaders = null;
        this.fallBack = true;
        this.isSigning = false;
        this.init(headerStream, true);
    }

    public void initSign(ByteArrayOutputStream headerStream) throws DkimException {
        this.headerStack = new Stack();
        this.signHeaders = null;
        this.isSigning = true;
        this.init(headerStream, false);
    }

    public Stack<String> getDkimHeaders() throws DkimException {
        if (this.dkimSigs == null) {
            throw new DkimException(DkimError.LIBERROR, "Multiple headers must be configured with initVerify()");
        }
        return this.dkimSigs;
    }

    public Stack<String> getDomKeyHeaders() throws DkimException {
        if (this.domKeySigs == null) {
            throw new DkimException(DkimError.LIBERROR, "Multiple headers must be configured with initVerify()");
        }
        return this.domKeySigs;
    }

    private String init(ByteArrayOutputStream headerStream, boolean multiple) throws DkimException {
        String domKeySig = null;
        String dkimSig = null;
        if (multiple) {
            this.dkimSigs = new Stack();
            this.domKeySigs = new Stack();
        }
        Scanner mail = new Scanner(headerStream.toString());
        mail.useDelimiter(Pattern.compile("[\r\n]"));
        while (mail.hasNextLine()) {
            int colon;
            String line = mail.nextLine();
            while (mail.hasNextLine()) {
                if (!mail.hasNext(Pattern.compile("(?m)^\\s+.*"))) break;
                line = String.valueOf(line) + "\r\n" + mail.nextLine();
            }
            if ((colon = line.indexOf(58)) == -1) {
                throw new DkimException(DkimError.PERMFAIL, "Broken Mail Header encountered, Message rejected.");
            }
            this.headerStack.push(line.substring(colon + 1));
            this.headerStack.push(line.substring(0, colon));
            if (line.toLowerCase().startsWith("domainkey-signature")) {
                line = line.replaceAll("[\t\r\n ]+", " ");
                domKeySig = line.trim();
                if (!multiple) continue;
                this.domKeySigs.push(domKeySig);
                continue;
            }
            if (!line.toLowerCase().startsWith("dkim-signature")) continue;
            line = line.replaceAll("[\r\n\t ]+", " ");
            dkimSig = line.trim();
            if (!multiple) continue;
            this.dkimSigs.push(dkimSig);
        }
        if (this.isSigning) {
            return null;
        }
        if (this.useDKIM && dkimSig != null) {
            return dkimSig;
        }
        if (!this.useDKIM && domKeySig != null) {
            return domKeySig;
        }
        if (this.fallBack && this.useDKIM && domKeySig != null) {
            return domKeySig;
        }
        if (this.fallBack && !this.useDKIM && dkimSig != null) {
            return dkimSig;
        }
        throw new DkimException(DkimError.NOSIG);
    }
}

