/*
 * Decompiled with CFR 0.152.
 */
package badpenguin.dkim.test;

import badpenguin.dkim.CanonicalMethod;
import badpenguin.dkim.DkimError;
import badpenguin.dkim.DkimException;
import badpenguin.dkim.DkimSignature;
import badpenguin.dkim.NSKeyStore;
import badpenguin.dkim.Signer;
import badpenguin.dkim.Verifier;
import badpenguin.dkim.test.KeyManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import sun.misc.BASE64Encoder;

public class Test {
    public static void main(String[] args) {
        Test test = new Test();
        test.run();
    }

    public void run() {
        FileInputStream store = null;
        try {
            store = new FileInputStream("/home/mark/src/dkim_store.dat");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        KeyManager km = new KeyManager(store, "hello123");
        PrivateKey key = km.getKey("mykey");
        PublicKey cert = km.getCert("mykey");
        System.err.println(cert.getFormat());
        BASE64Encoder bs = new BASE64Encoder();
        System.err.println("Cert: " + bs.encode(cert.getEncoded()));
        Signer signer = null;
        FileInputStream msg = null;
        FileOutputStream out = null;
        try {
            msg = new FileInputStream("/home/mark/savagemail.txt");
            DkimSignature dksig = new DkimSignature("test1", "badpenguin.co.uk");
            dksig.setMethod(CanonicalMethod.RELAXED);
            dksig.addHeader("received");
            dksig.addHeader("received");
            dksig.setItag("dkim@badpenguin.co.uk");
            signer = new Signer(dksig, key);
            out = new FileOutputStream("/home/mark/savagesigned.txt");
            signer.signMail(msg, out);
            out.close();
            ((InputStream)msg).close();
            NSKeyStore keyStore = new NSKeyStore("dns", "212.23.3.100");
            Verifier ver = new Verifier(keyStore, "DomainKey");
            ver.setleniency(true);
            msg = new FileInputStream("/home/mark/savagesigned.txt");
            if (ver.verifyMail(msg)) {
                System.out.println("Message Verified ;-)");
            } else {
                System.out.println("Message failed to verify :-(");
            }
            ((InputStream)msg).close();
        }
        catch (DkimException d) {
            if (d.getError().equals((Object)DkimError.TEMPFAIL)) {
                d.printStackTrace();
            } else if (d.getError().equals((Object)DkimError.PERMFAIL)) {
                d.printStackTrace();
            } else {
                d.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

