/*
 * Decompiled with CFR 0.152.
 */
package badpenguin.dkim;

import badpenguin.dkim.Canonicaliser;
import badpenguin.dkim.DkimError;
import badpenguin.dkim.DkimException;
import badpenguin.dkim.DkimSignature;
import badpenguin.dkim.MailMessage;
import badpenguin.dkim.NSKey;
import badpenguin.dkim.NSKeyStore;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Verifier {
    private String sigPref = null;
    private boolean leniency = false;
    private NSKeyStore keyStore = null;
    private boolean tryBoth = false;

    public Verifier(NSKeyStore arg0, String arg1, boolean arg2) {
        this._Verifier(arg0, arg1, this.tryBoth);
    }

    public Verifier(NSKeyStore arg0, String arg1) {
        this._Verifier(arg0, arg1, true);
    }

    public Verifier(NSKeyStore arg0) {
        this._Verifier(arg0, "DKIM", true);
    }

    private void _Verifier(NSKeyStore arg0, String arg1, boolean arg2) {
        this.tryBoth = arg2;
        this.sigPref = arg1;
        this.keyStore = arg0;
        this.leniency = false;
    }

    public void setleniency(boolean arg0) {
        this.leniency = arg0;
    }

    public void tryBoth(boolean arg0) {
        this.tryBoth = arg0;
    }

    private boolean checkBodyHash(DkimSignature dkimSig, String mailBody) {
        MessageDigest md = null;
        try {
            md = dkimSig.getJavaAlg().equals("SHA256withRSA") ? MessageDigest.getInstance("SHA-256") : MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        md.update(mailBody.getBytes());
        BASE64Encoder bsenc = new BASE64Encoder();
        String digest = bsenc.encode(md.digest());
        return digest.equals(dkimSig.getBodyHash());
    }

    private boolean checkGranularity(DkimSignature dkimSig, NSKey nsKey) {
        int local;
        String granularity = nsKey.getGranularity();
        if (granularity.equals("*")) {
            return true;
        }
        if (this.leniency && granularity.isEmpty()) {
            return true;
        }
        String iTag = dkimSig.getItag();
        if (!iTag.equals("\u0000") && (local = iTag.indexOf("@")) > 0) {
            granularity = granularity.replaceAll("\\*", ".*");
            if (!iTag.substring(0, local).matches(granularity)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkSubdomains(DkimSignature dkimSig, NSKey nsKey) {
        if (nsKey.noSubdomains()) {
            String Itag = dkimSig.getItag();
            if (Itag.equals("\u0000")) {
                return true;
            }
            String domain = Itag.substring(Itag.indexOf(64) + 1);
            if (!domain.equals(dkimSig.getDtag())) {
                return false;
            }
        }
        return true;
    }

    private boolean checkHashAlgorithm(DkimSignature dkimSig, NSKey nsKey) {
        String Atag = dkimSig.getAtag();
        String[] hashes = nsKey.getHashAlgorithm().split(":");
        int i = 0;
        while (i < hashes.length) {
            if (Atag.endsWith(hashes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean verifyMail(InputStream msg) throws IOException, DkimException {
        boolean dkim;
        block13: {
            Signature sig = null;
            Canonicaliser canon = new Canonicaliser(this.sigPref);
            MailMessage mail = new MailMessage();
            mail.processMail(msg);
            DkimSignature dkimSig = new DkimSignature(canon.initVerify(mail.getHeaders(), this.tryBoth), this.leniency);
            String mailHeaders = canon.processHeaders(dkimSig);
            dkimSig.checkValidity();
            dkim = dkimSig.isDKIM();
            String mailBody = canon.processBody(mail.getBody(), dkimSig.getLtag(), dkimSig.getBodyMethod());
            NSKey nsKey = this.keyStore.retrieveKey(dkimSig.getDnsRecord());
            if (!this.checkGranularity(dkimSig, nsKey)) {
                if (dkim) {
                    throw new DkimException(DkimError.PERMFAIL, "Inapplicable key");
                }
                throw new DkimException(DkimError.NOKEY, "Inapplicable key");
            }
            if (!this.checkSubdomains(dkimSig, nsKey)) {
                throw new DkimException(DkimError.PERMFAIL, "Inapplicable key. Subdomains not allowed");
            }
            if (!this.checkHashAlgorithm(dkimSig, nsKey)) {
                throw new DkimException(DkimError.PERMFAIL, "Inapplicable hash algorithm specified in public key record");
            }
            if (dkim && !this.checkBodyHash(dkimSig, mailBody)) {
                return false;
            }
            BASE64Decoder bs = new BASE64Decoder();
            byte[] sigBuf = bs.decodeBuffer(dkimSig.getBtag());
            sig = Signature.getInstance(dkimSig.getJavaAlg());
            sig.initVerify(nsKey.getKey());
            sig.update(mailHeaders.getBytes());
            if (!dkim) {
                sig.update("\r\n".getBytes());
                sig.update(mailBody.getBytes());
            }
            if (!sig.verify(sigBuf)) break block13;
            return true;
        }
        try {
            System.err.println("Signature verification failed");
            return false;
        }
        catch (NoSuchAlgorithmException n) {
            n.printStackTrace();
        }
        catch (InvalidKeyException k) {
            if (dkim) {
                throw new DkimException(DkimError.PERMFAIL, "The Key found was invalid", k);
            }
            throw new DkimException(DkimError.BADFORMAT, "The Key found was invalid", k);
        }
        catch (SignatureException s) {
            if (dkim) {
                throw new DkimException(DkimError.PERMFAIL, "Could not process the signature data", s);
            }
            throw new DkimException(DkimError.BADFORMAT, "The Key found was invalid", s);
        }
        return false;
    }
}

