/*
 * Decompiled with CFR 0.152.
 */
package badpenguin.dkim;

import badpenguin.dkim.Canonicaliser;
import badpenguin.dkim.DkimError;
import badpenguin.dkim.DkimException;
import badpenguin.dkim.DkimSignature;
import badpenguin.dkim.MailMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import sun.misc.BASE64Encoder;

public class Signer {
    DkimSignature dkimSig = null;
    private PrivateKey privateKey = null;

    public Signer(String selector, String domain, String headers, String alg, PrivateKey key) throws DkimException {
        this.dkimSig = new DkimSignature(selector, domain, headers);
        this.dkimSig.setAtag(alg);
        this.privateKey = key;
        this.newSig();
    }

    public Signer(String selector, String domain, String alg, PrivateKey key) throws DkimException {
        this.dkimSig = new DkimSignature(selector, domain);
        this.dkimSig.setAtag(alg);
        this.privateKey = key;
        this.newSig();
    }

    public Signer(DkimSignature DKIMSig, PrivateKey key) throws DkimException {
        this.dkimSig = DKIMSig;
        this.privateKey = key;
        this.newSig();
    }

    private Signature newSig() throws DkimException {
        Signature mailSig = null;
        try {
            mailSig = Signature.getInstance(this.dkimSig.getJavaAlg());
            mailSig.initSign(this.privateKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DkimException(DkimError.LIBERROR, "Failed to find specified algorithm", e);
        }
        catch (InvalidKeyException e) {
            throw new DkimException(DkimError.LIBERROR, "Invalid key specified", e);
        }
        return mailSig;
    }

    private String genBodyHash(String mailBody, DkimSignature dks) {
        MessageDigest md = null;
        try {
            md = dks.getJavaAlg().equals("SHA256withRSA") ? MessageDigest.getInstance("SHA-256") : MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        md.update(mailBody.getBytes());
        BASE64Encoder bsenc = new BASE64Encoder();
        String digest = bsenc.encode(md.digest());
        return digest;
    }

    public String signMail(InputStream msg) throws DkimException {
        MailMessage mail = new MailMessage();
        mail.processMail(msg);
        DkimSignature dks = this.worker(mail);
        return dks.getDkimSig();
    }

    public void signMail(InputStream msg, OutputStream out) throws DkimException {
        MailMessage mail = new MailMessage();
        mail.processMail(msg);
        DkimSignature dks = this.worker(mail);
        try {
            out.write(mail.getHeaders().toByteArray());
            out.write(dks.getDkimSig().getBytes());
            out.write("\r\n".getBytes());
            out.write(mail.getBody().toByteArray());
            out.flush();
        }
        catch (IOException e) {
            throw new DkimException(DkimError.LIBERROR, "IOException occurred while writing message", e);
        }
    }

    private DkimSignature worker(MailMessage mail) throws DkimException {
        DkimSignature dks = null;
        try {
            dks = this.dkimSig.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DkimException(DkimError.LIBERROR, "Internal error, DKIM Signature clone failed", e);
        }
        Signature sig = this.newSig();
        Canonicaliser canon = new Canonicaliser();
        canon.initSign(mail.getHeaders());
        String mailBody = canon.processBody(mail.getBody(), dks.getLtag(), dks.getBodyMethod());
        String digest = this.genBodyHash(mailBody, dks);
        dks.setBHtag(digest);
        String mailHeaders = canon.processHeaders(dks);
        try {
            sig.update(mailHeaders.getBytes());
            BASE64Encoder bsenc = new BASE64Encoder();
            dks.setBtag(bsenc.encode(sig.sign()));
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        return dks;
    }
}

