/*
 * Decompiled with CFR 0.152.
 */
package badpenguin.dkim;

import badpenguin.dkim.DkimError;
import badpenguin.dkim.DkimException;
import badpenguin.dkim.NSKey;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class NSKeyStore {
    private static Hashtable<String, NSKey> keyMap = null;
    private DirContext dnsCtx = null;

    public NSKeyStore(String type, String dnsServer) throws NamingException {
        if (!type.equals("dns")) {
            throw new NamingException("Only the DNS name service is supported");
        }
        keyMap = new Hashtable();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", "dns://" + dnsServer);
        this.dnsCtx = new InitialDirContext(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSKey retrieveKey(String lookup) throws DkimException {
        if (keyMap.containsKey(lookup)) {
            return keyMap.get(lookup);
        }
        Attributes attrs = null;
        try {
            attrs = this.dnsCtx.getAttributes(lookup, new String[]{"txt"});
        }
        catch (NamingException e) {
            if (e.getMessage().contains("name not found")) {
                throw new DkimException(DkimError.PERMFAIL, "No key for signature found at " + lookup, e);
            }
            throw new DkimException(DkimError.TEMPFAIL, "Failed to perform NameService lookup", e);
        }
        String record = attrs.toString();
        NSKey nsKey = new NSKey(record);
        Hashtable<String, NSKey> hashtable = keyMap;
        synchronized (hashtable) {
            if (!keyMap.contains(lookup)) {
                keyMap.put(lookup, nsKey);
            }
        }
        return nsKey;
    }
}

