/*
 * Decompiled with CFR 0.152.
 */
package badpenguin.dkim;

import badpenguin.dkim.DkimError;
import badpenguin.dkim.DkimException;
import java.security.PublicKey;
import java.util.Scanner;
import sun.misc.BASE64Decoder;
import sun.security.rsa.RSAPublicKeyImpl;

public class NSKey {
    private PublicKey key = null;
    private String version = "DKIM1";
    private String granularity = "*";
    private String hash = "sha1:sha256";
    private String type = "rsa";
    private String notes = null;
    private String service = "*";
    private boolean testing = false;
    private boolean noSubdomains = false;

    public NSKey(String record) throws DkimException {
        record = record.replace("{txt=TXT: ", "");
        Scanner keyScan = new Scanner(record);
        keyScan.useDelimiter("[\\;]");
        while (keyScan.hasNext()) {
            String line = keyScan.next().replaceAll("[\t\" ]", "");
            String[] tag = line.trim().split("=", 2);
            if (tag[0].equals("g")) {
                this.granularity = tag[1];
                continue;
            }
            if (tag[0].equals("t")) {
                int i = 0;
                if (tag[1].contains("y")) {
                    this.testing = true;
                    ++i;
                    continue;
                }
                if (!tag[1].contains("s")) continue;
                this.noSubdomains = true;
                continue;
            }
            if (tag[0].equals("p")) {
                if (tag[1].isEmpty()) {
                    throw new DkimException(DkimError.PERMFAIL, "The Key has been revoked.");
                }
                try {
                    BASE64Decoder decoder = new BASE64Decoder();
                    byte[] decoded = decoder.decodeBuffer(tag[1]);
                    this.key = new RSAPublicKeyImpl(decoded);
                    continue;
                }
                catch (Exception e) {
                    throw new DkimException(DkimError.PERMFAIL, "The Key seems to be invalid", e);
                }
            }
            if (tag[0].equals("v")) {
                if (tag[1].equals("DKIM1")) continue;
                throw new DkimException(DkimError.PERMFAIL, "Unsupported DKIM version in txt record");
            }
            if (tag[0].equals("h")) {
                this.hash = tag[1];
                continue;
            }
            if (!tag[0].equals("k") || tag[1].equals("rsa")) continue;
            throw new DkimException(DkimError.PERMFAIL, "Unsupported key type in txt record");
        }
        if (this.key == null) {
            throw new DkimException(DkimError.PERMFAIL, "No KEY found in txt record");
        }
    }

    public PublicKey getKey() {
        return this.key;
    }

    public boolean isTesting() {
        return this.testing;
    }

    public boolean noSubdomains() {
        return this.noSubdomains;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public String getHashAlgorithm() {
        return this.hash;
    }
}

