/*
 * Decompiled with CFR 0.152.
 */
package badpenguin.dkim;

import badpenguin.dkim.CanonicalMethod;
import badpenguin.dkim.DkimError;
import badpenguin.dkim.DkimException;
import badpenguin.dkim.DkimSignature;
import java.io.ByteArrayOutputStream;
import java.util.Scanner;
import java.util.Stack;
import java.util.regex.Pattern;

public class Canonicaliser {
    private static final CanonicalMethod SIMPLE = CanonicalMethod.SIMPLE;
    private static final CanonicalMethod RELAXED = CanonicalMethod.RELAXED;
    private static final CanonicalMethod NOFWS = CanonicalMethod.NOFWS;
    private boolean useDKIM = false;
    private boolean fallBack = false;
    private boolean isSigning = false;
    private Stack<String> headerStack = null;
    private String signHeaders = null;

    public Canonicaliser(String sigPref) {
        this.useDKIM = sigPref.equalsIgnoreCase("DKIM") ? true : !sigPref.equalsIgnoreCase("DomainKey");
        this.fallBack = false;
    }

    public Canonicaliser() {
        this.useDKIM = true;
        this.fallBack = false;
    }

    protected String processLine(String line, CanonicalMethod method) {
        if (method.equals((Object)NOFWS)) {
            line = line.replaceAll("[\t\r\n ]", "");
            line = String.valueOf(line) + "\r\n";
        } else if (method.equals((Object)RELAXED)) {
            line = line.replaceAll("[\r\n\t ]+", " ");
            line = line.replaceAll("(?m)[\t\r\n ]+$", "");
            line = String.valueOf(line) + "\r\n";
        } else if (method.equals((Object)SIMPLE)) {
            line = String.valueOf(line) + "\r\n";
        }
        return line;
    }

    public String processBody(ByteArrayOutputStream bodyStream, long length, CanonicalMethod method) {
        String mailBody = "";
        if (length == 0L) {
            return "\r\n";
        }
        Scanner mail = new Scanner(bodyStream.toString());
        mail.useDelimiter(Pattern.compile("[\r\n]"));
        while (mail.hasNextLine()) {
            String line = mail.nextLine();
            mailBody = String.valueOf(mailBody) + this.processLine(line, method);
        }
        mailBody = mailBody.replaceAll("[\t \r\n]+$", "\r\n");
        return mailBody;
    }

    /*
     * Unable to fully structure code
     */
    public String processHeaders(DkimSignature dkimSig) throws DkimException {
        block15: {
            if (this.signHeaders != null) {
                return this.signHeaders;
            }
            this.signHeaders = "";
            if (this.headerStack == null) {
                throw new DkimException(DkimError.LIBERROR, "You must call initHeaders first!");
            }
            sigHtag = dkimSig.getHtag();
            method = dkimSig.getHeaderMethod();
            isDKIM = dkimSig.isDKIM();
            if (isDKIM && (sigHtag == null || sigHtag.isEmpty())) {
                throw new DkimException(DkimError.PERMFAIL, "The madatory H tag appears to be missing from the DKIM-Signature");
            }
            if (sigHtag == "\u0000") ** GOTO lbl47
            if (isDKIM) {
                sigHtag = String.valueOf(sigHtag) + ":dkim-signature";
            }
            headers = sigHtag.split(":");
            headerCount = headers.length;
            values = new String[headerCount];
            block0: while (!this.headerStack.isEmpty()) {
                header = this.headerStack.pop();
                index = 0;
                while (index < headerCount) {
                    if (header.equalsIgnoreCase(headers[index])) {
                        headers[index] = header;
                        if (values[index] == null) {
                            values[index] = this.processLine(this.headerStack.pop(), method).trim();
                            if (!headers[index].equalsIgnoreCase("dkim-signature")) continue block0;
                            values[index] = values[index].replaceAll("b=[A-Za-z0-9+/= ]+", "b=");
                            continue block0;
                        }
                    }
                    ++index;
                }
            }
            if (this.isSigning) {
                values[headerCount - 1] = this.processLine(dkimSig.getDkimSig().replace("DKIM-Signature: ", ""), method);
            }
            index = 0;
            while (index < headers.length) {
                if (method.equals((Object)Canonicaliser.NOFWS)) {
                    this.signHeaders = String.valueOf(this.signHeaders) + this.processLine(String.valueOf(headers[index]) + ":" + values[index], method);
                } else if (method.equals((Object)Canonicaliser.RELAXED)) {
                    this.signHeaders = String.valueOf(this.signHeaders) + this.processLine(String.valueOf(headers[index].toLowerCase()) + ":" + values[index], method);
                }
                ++index;
            }
            break block15;
lbl-1000:
            // 1 sources

            {
                header = this.headerStack.pop();
                value = this.headerStack.pop();
                if (header.equalsIgnoreCase("DomainKey-Signature")) continue;
                this.signHeaders = String.valueOf(this.processLine(String.valueOf(header) + ":" + value, method)) + this.signHeaders;
lbl47:
                // 3 sources

                ** while (!this.headerStack.isEmpty())
            }
        }
        if (isDKIM) {
            this.signHeaders = this.signHeaders.replaceAll("(?m)[\r\n]+$", "");
        }
        return this.signHeaders;
    }

    public String initVerify(ByteArrayOutputStream headerStream, boolean fallback) throws DkimException {
        this.headerStack = new Stack();
        this.signHeaders = null;
        this.fallBack = fallback;
        this.isSigning = false;
        return this.init(headerStream);
    }

    public void initSign(ByteArrayOutputStream headerStream) throws DkimException {
        this.headerStack = new Stack();
        this.signHeaders = null;
        this.isSigning = true;
        this.init(headerStream);
    }

    private String init(ByteArrayOutputStream headerStream) throws DkimException {
        String domKeySig = null;
        String dkimSig = null;
        Scanner mail = new Scanner(headerStream.toString());
        mail.useDelimiter(Pattern.compile("[\r\n]"));
        while (mail.hasNextLine()) {
            String line = mail.nextLine();
            while (mail.hasNextLine()) {
                if (!mail.hasNext(Pattern.compile("(?m)^\\s+.*"))) break;
                line = String.valueOf(line) + "\r\n" + mail.nextLine();
            }
            int colon = line.indexOf(58);
            this.headerStack.push(line.substring(colon + 1));
            this.headerStack.push(line.substring(0, colon));
            if (line.startsWith("DomainKey-Signature")) {
                line = line.replaceAll("[\t\r\n ]+", "");
                domKeySig = line.trim();
                continue;
            }
            if (!line.startsWith("DKIM-Signature")) continue;
            line = line.replaceAll("[\r\n\t ]+", "");
            dkimSig = line.trim();
        }
        if (this.isSigning) {
            return null;
        }
        if (this.useDKIM && dkimSig != null) {
            return dkimSig;
        }
        if (!this.useDKIM && domKeySig != null) {
            return domKeySig;
        }
        if (this.fallBack && this.useDKIM && domKeySig != null) {
            return domKeySig;
        }
        if (this.fallBack && !this.useDKIM && dkimSig != null) {
            return dkimSig;
        }
        if (this.useDKIM) {
            throw new DkimException(DkimError.PERMFAIL, "No DKIM-Signature header was found");
        }
        throw new DkimException(DkimError.NOSIG);
    }
}

