/**
 * Java implementation of DKIM/DomainKeys. 
 * Copyright (c) 2008 Mark Boddington (www.badpenguin.co.uk)
 * 
 * This program is licensed under the terms of the GNu GPL version 2.0.
 * The DKIM specification is documented in RFC 4871
 * See: http://www.ietf.org/rfc/rfc4871.txt
 */
package badpenguin.dkim.test;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.PrivateKey;

import badpenguin.dkim.CanonicalMethod;
import badpenguin.dkim.DkimError;
import badpenguin.dkim.DkimException;
import badpenguin.dkim.DkimSignature;
import badpenguin.dkim.NSKeyStore;
import badpenguin.dkim.Signer;
import badpenguin.dkim.Verifier;

import sun.misc.BASE64Encoder;

public class Test {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		Test test = new Test();
		test.run();
	}
	
	public void run() {
		FileInputStream store = null;
		try {
			store = new FileInputStream("/home/mark/src/dkim_store.dat");
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		KeyManager km = new KeyManager(store, "hello123");
		PrivateKey key = (PrivateKey) km.getKey("mykey");
		//Signer signer = null;
		//try {
		//	signer = new Signer("rsa-SHA256", "foo", "bar", key);
		//} catch (Exception e) {
		//	e.printStackTrace();
		//}
		
		try {
			NSKeyStore keyStore = new NSKeyStore("dns", "212.23.3.100");
			Verifier ver = new Verifier(keyStore, "DKIM");
			InputStream msg = new FileInputStream("/home/mark/googlemail.txt");
			
			if ( ver.verifyMail(msg) )
				System.out.println("Message Verified ;-)");
			else 
				System.out.println("Message failed to verify :-(");
			
			msg.close();
			
			msg = new FileInputStream("/home/mark/mymail.txt");
			DkimSignature dksig = new DkimSignature("savage", "badpenguin.co.uk");
			dksig.setMethod(CanonicalMethod.RELAXED);
			dksig.setItag("dkim@badpenguin.co.uk");
			Signer signer = new Signer(dksig,key);
			String header = signer.signMail(msg);
			System.out.println(header);
			msg.close();
			
		
			//signer.addSignedHeader("received");
			//signer.addSignedHeader("received");
			//signer.setRelaxed(true);
			
			//System.out.println(signer.getCanonicalization());
			//System.out.println(signer.getSignedHeaders());
			//System.out.println(signer.signMail(msg));
			//msg.reset();
			//System.out.println(signer.signMail(msg));
			msg.close();
		} catch (DkimException d) {
			if ( d.getError().equals(DkimError.TEMPFAIL)) {
				// message failed, but may succeed later
				d.printStackTrace();
			} else if ( d.getError().equals(DkimError.PERMFAIL)) {
				// message failed and will never verify
				d.printStackTrace();
			} else {
				// domainkey error
				d.printStackTrace();
			}
		} catch ( Exception e) {
			e.printStackTrace();
		}
		
	}

}
